from random import shuffle

import ctypes
from ctypes.util import find_library

libc = ctypes.cdll.LoadLibrary(find_library("c"))

CMPFUNC = ctypes.CFUNCTYPE(
    # Typ zwracanej wartości.
    ctypes.c_int,
    # Typ pierwszego argumentu.
    ctypes.POINTER(ctypes.c_int),
    # Typ drugiego argumentu.
    ctypes.POINTER(ctypes.c_int),
)


def ctypes_int_compare(a, b):
    # Argumenty są wskaźnikami, dlatego dostęp do wartości odbywa się za pomocą składni [0].    
    print(" %s cmp %s" % (a[0], b[0]))

    # Zgodnie ze specyfikacją funkcji qsort kod ma zwracać:
    # * wartość mniejszą od zera, jeśli a < b
    # * zero, jeśli a == b
    # * wartość większą od zera, jeśli if a > b
    return a[0] - b[0]


def main():
    numbers = list(range(5))
    shuffle(numbers)
    print("Wymieszane: ", numbers)

    # Tworzenie nowego typu reprezentującego tablicę o długości
    # takiej samej jak długość listy numbers.
    NumbersArray = ctypes.c_int * len(numbers)
    # Tworzenie nowej tablicy w C za pomocą nowego typu.
    c_array = NumbersArray(*numbers)

    libc.qsort(
        # Wskaźnik do posortowanej tablicy.
        c_array,
        # Długość tablicy.
        len(c_array),
        # Długość jednego elementu tablicy.
        ctypes.sizeof(ctypes.c_int),
        # Wywoływana zwrotnie funkcja (wskaźnik do funkcji porównującej elementy w C).
        CMPFUNC(ctypes_int_compare),
    )
    print("Posortowane: ", list(c_array))


if __name__ == "__main__":
    main()
